/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core.sourcelookup;

import com.aptana.debug.core.sourcelookup.IFileContentRetriever;
import com.aptana.debug.core.sourcelookup.RemoteFileStorage;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;

public final class RemoteSourceCacheManager
implements IDebugEventSetListener {
    private Map<URI, RemoteFileStorage> cache = new HashMap<URI, RemoteFileStorage>();
    private IFileContentRetriever fileContentRetriever;

    public synchronized RemoteFileStorage getStorage(URI uri) {
        return this.cache.get(uri);
    }

    public synchronized void add(URI uri, RemoteFileStorage storage) {
        this.cache.put(uri, storage);
        if (storage.getFileContentRetriever() == null) {
            storage.setFileContentRetriever(this.fileContentRetriever);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() instanceof IDebugTarget) {
                switch (event.getKind()) {
                    case 4: {
                        this.updateStorageContent((IDebugTarget)event.getSource(), false);
                        break;
                    }
                    case 8: {
                        this.updateStorageContent((IDebugTarget)event.getSource(), true);
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    private synchronized void updateStorageContent(IDebugTarget target, boolean clear) {
        this.fileContentRetriever = (IFileContentRetriever)target.getAdapter(IFileContentRetriever.class);
        if (this.fileContentRetriever != null) {
            for (RemoteFileStorage storage : this.cache.values()) {
                if (clear) {
                    if (storage.getFileContentRetriever() != this.fileContentRetriever) continue;
                    storage.setFileContentRetriever(null);
                    continue;
                }
                if (storage.getFileContentRetriever() != null) continue;
                storage.setFileContentRetriever(this.fileContentRetriever);
            }
        }
        if (clear) {
            this.fileContentRetriever = null;
        }
    }
}

